﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.IO;
using System.Text.RegularExpressions;

namespace Tlumacz
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            comboBox1.SelectedIndex = 0;
            Form1_Resize(null, null);
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            textBox1.Height = textBox2.Height = 
                (this.ClientRectangle.Height - comboBox1.Height) / 2;
        }

        public static string GoogleTranslate(string tekstDoPrzetlumaczenia, string paraJezykow, Encoding kodowanie)
        {
            string url = String.Format(
                "http://translate.google.pl/translate_t?text={0}&langpair={1}",
                tekstDoPrzetlumaczenia, paraJezykow);
            string tekstPoPrzetlumaczeniu = "";
            HttpWebResponse odpowiedzHTTP = null;
            Stream stream = null;
            try
            {
                HttpWebRequest zapytanieHTTP = (HttpWebRequest)HttpWebRequest.Create(url);
                odpowiedzHTTP = (HttpWebResponse)zapytanieHTTP.GetResponse();
                stream = odpowiedzHTTP.GetResponseStream();
                using (StreamReader reader = new StreamReader(stream, kodowanie))
                {
                    tekstPoPrzetlumaczeniu = reader.ReadToEnd();
                }

                Regex regexp = new Regex(
                    "(?<=<input type=hidden name=gtrans value=\")(.*?)(?=\">)",
                    RegexOptions.IgnoreCase);
                Match m = regexp.Match(tekstPoPrzetlumaczeniu);
                if (m.Success) tekstPoPrzetlumaczeniu = m.Value;
                else
                {
                    tekstPoPrzetlumaczeniu = "";
                    throw new Exception();
                }
            }
            catch
            {
                MessageBox.Show("Nie udało się przetłumaczyć tekstu.", "Błąd!");
            }
            finally
            {
                if (odpowiedzHTTP != null) odpowiedzHTTP.Close();
                if (stream != null) stream.Close();
            }
            return tekstPoPrzetlumaczeniu;
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            string paraJezykow="en|pl";
            switch(comboBox1.SelectedIndex)
            {
                case 0: paraJezykow="en|pl"; break;
                case 1: paraJezykow="pl|en"; break;
            }
            textBox2.Text = GoogleTranslate(textBox1.Text, paraJezykow, Encoding.GetEncoding("ISO-8859-2"));

            Cursor.Current = Cursors.Default;
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                Biblia.TheHolyBible biblia = new Biblia.TheHolyBible();
                //DataSet ds = biblia.GetContentByBookChapter(1, 1); //cały rozdział
                DataSet ds = biblia.GetContentByBookChapterVerse(1, 1, 1); //pojedynczy werset
                DataTable dt = ds.Tables[0];

                var linq = from data in dt.AsEnumerable()
                           select data.Field<string>("Content");
                textBox1.Text = "";
                foreach (string s in linq)
                {
                    textBox1.Text += s.ToString() + " ";
                }

                comboBox1.SelectedIndex = 0;
                textBox2.Text = GoogleTranslate(textBox1.Text, "en|pl", Encoding.GetEncoding("ISO-8859-2"));
            }
            catch
            {
                MessageBox.Show(
                    "Wystąpił błąd podczas próby skorzystania z usługi sieciowej.", "Błąd!");
            }
            Cursor.Current = Cursors.Default;
        }

    }
}